<?php
 
/* Pass in by reference! */
function graph_rperf_report ( &$rrdtool_graph ) {

   global $conf,
          $context,
          $hostname,
          $range,
          $rrd_dir,
          $size,
          $max_unique_colors,
          $unique_color;

   if ($conf['strip_domainname']) {
      $hostname = strip_domainname($hostname);
   }

   $title = 'rPerf Usage';

   if ($context != "host") {
      $rrdtool_graph['title'] = $title;
   } else {
      $rrdtool_graph['title'] = "$hostname $title last $range";
   }

   $rrdtool_graph['vertical-label'] = 'rPerf';
// Fudge to account for number of lines in the chart legend
   $rrdtool_graph['height']        += ($size == 'medium') ? 28 : 0 ;
   $rrdtool_graph['lower-limit']    = '0';
   $rrdtool_graph['extras']         = '--rigid';

   $series = '';

   if (($size != 'large') && ($size != 'xlarge')) {
      $rrdtool_graph['extras'] .= ($conf['graphreport_stats'] == true) ? ' --font LEGEND:7' : '';
      /* we obtain the information from __SummaryInfo__ */
      if (file_exists( "${rrd_dir}/rperf.rrd" )) {
         $series =
         "DEF:'rperf'='${rrd_dir}/rperf.rrd':'sum':AVERAGE "
         ."AREA:'rperf'#$unique_color[1]:'rPerf\\n' ";

         if ($conf['graphreport_stats'] == true) {
            $series .= "CDEF:rperf_pos=rperf,0,LT,0,rperf,IF "
                . "VDEF:rperf_now=rperf_pos,LAST "
                . "VDEF:rperf_min=rperf_pos,MINIMUM "
                . "VDEF:rperf_avg=rperf_pos,AVERAGE "
                . "VDEF:rperf_max=rperf_pos,MAXIMUM "
                . "GPRINT:'rperf_now':'Now\:%7.2lf%s' "
                . "GPRINT:'rperf_min':'Min\:%7.2lf%s' "
                . "GPRINT:'rperf_avg':'Avg\:%7.2lf%s' "
                . "GPRINT:'rperf_max':'Max\:%7.2lf%s\\l' ";
         }
      }
   } else {
      // we have to obtain all metrics ourselves
      $pos = strpos( ${rrd_dir}, '__SummaryInfo__' );
      $cluster_dir = substr( ${rrd_dir}, 0, $pos-1 );

      $dh = opendir(${cluster_dir});

      $files = array();

      while (($file = readdir($dh)) !== false)
         if (($file != "__SummaryInfo__") && ($file != ".") && ($file != "..")) {
            array_push($files, $file);
         }

      closedir($dh);

      // sort the files
      sort($files);

      $i = 0;

      foreach ($files as $file) {
         if (file_exists( "${cluster_dir}/${file}/rperf.rrd" )) {
            $cmd =
            "DEF:'label$i'='${cluster_dir}/${file}/rperf.rrd':'sum':AVERAGE ";

            $color_index = $i % $max_unique_colors;

            if ($i == 0) {
               $cmd .= "AREA:'label$i'#$unique_color[$color_index]:'$file' ";
            } else {
               $cmd .= "STACK:'label$i'#$unique_color[$color_index]:'$file' ";
            }

            $series .= $cmd;

            $i += 1;
         }
      }
   }

   $rrdtool_graph['series'] = $series;

   return $rrdtool_graph;

}

?>
