<?php
 
/* Pass in by reference! */
function graph_SPECfp_rate2006_report ( &$rrdtool_graph ) {

   global $conf,
          $context,
          $hostname,
          $range,
          $rrd_dir,
          $size,
          $max_unique_colors,
          $unique_color;

   if ($conf['strip_domainname']) {
      $hostname = strip_domainname($hostname);
   }

   $title = 'SPECfp_rate2006 Usage';

   if ($context != "host") {
      $rrdtool_graph['title'] = $title;
   } else {
      $rrdtool_graph['title'] = "$hostname $title last $range";
   }

   $rrdtool_graph['vertical-label'] = 'SPECfp_rate2006';
// Fudge to account for number of lines in the chart legend
   $rrdtool_graph['height']        += ($size == 'medium') ? 28 : 0 ;
   $rrdtool_graph['lower-limit']    = '0';
   $rrdtool_graph['extras']         = '--rigid';

   $series = '';

   if (($size != 'large') && ($size != 'xlarge')) {
      $rrdtool_graph['extras'] .= ($conf['graphreport_stats'] == true) ? ' --font LEGEND:7' : '';
      // we obtain the information from __SummaryInfo__
      if (file_exists( "${rrd_dir}/SPECfp_rate2006.rrd" )) {
         $series =
         "DEF:'specfp'='${rrd_dir}/SPECfp_rate2006.rrd':'sum':AVERAGE "
         ."AREA:'specfp'#$unique_color[2]:'SPECfp_rate2006\\n' ";

         if ($conf['graphreport_stats'] == true) {
            $series .= "CDEF:spec_pos=specfp,0,LT,0,specfp,IF "
                . "VDEF:spec_now=spec_pos,LAST "
                . "VDEF:spec_min=spec_pos,MINIMUM "
                . "VDEF:spec_avg=spec_pos,AVERAGE "
                . "VDEF:spec_max=spec_pos,MAXIMUM "
                . "GPRINT:'spec_now':'Now\:%7.2lf%s' "
                . "GPRINT:'spec_min':'Min\:%7.2lf%s' "
                . "GPRINT:'spec_avg':'Avg\:%7.2lf%s' "
                . "GPRINT:'spec_max':'Max\:%7.2lf%s\\l' ";
         }
      }
   } else {
      // we have to obtain all metrics ourselves
      $pos = strpos( ${rrd_dir}, '__SummaryInfo__' );
      $cluster_dir = substr( ${rrd_dir}, 0, $pos-1 );

      $dh = opendir(${cluster_dir});

      $files = array();

      while (($file = readdir($dh)) !== false)
         if (($file != "__SummaryInfo__") && ($file != ".") && ($file != "..")) {
            array_push($files, $file);
         }

      closedir($dh);

      // sort the files
      sort($files);

      $i = 0;

      foreach ($files as $file) {
         if (file_exists( "${cluster_dir}/${file}/SPECfp_rate2006.rrd" )) {
            $cmd =
            "DEF:'label$i'='${cluster_dir}/${file}/SPECfp_rate2006.rrd':'sum':AVERAGE ";

            $color_index = $i % $max_unique_colors;

            if ($i == 0) {
               $cmd .= "AREA:'label$i'#$unique_color[$color_index]:'$file' ";
            } else {
               $cmd .= "STACK:'label$i'#$unique_color[$color_index]:'$file' ";
            }

            $series .= $cmd;

            $i += 1;
         }
      }
   }

   $rrdtool_graph['series'] = $series;

   return $rrdtool_graph;

}

?>
